/*+ NmeaParser.h
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2007 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file defines the CNmeaParser class.
 *            
 * Revision History:
 *    01-11-2007    Jacob Norda
 *                  Written
 *
 * Notes:
 *
-*/

#ifndef NMEA_PARSER_H
#define NMEA_PARSER_H

/*---------------------------------------------------------------------------*\
 |                         I N C L U D E   F I L E S
\*---------------------------------------------------------------------------*/
#include "ParserDefinitions.h"


/*---------------------------------------------------------------------------*\
 |                  C O N S T A N T S   A N D   M A C R O S
\*---------------------------------------------------------------------------*/
#define MAX_NMEA_PKT_LEN 300  // max length of an NMEA packet 

#define NMEA_START   0x24              /* $ - NMEA start of message            */
#define NMEA_END_CR  0x0D              /* <cr> - NMEA end of message           */
#define NMEA_END_LF  0x0A              /* <lf> - NMEA end of message           */

/*---------------------------------------------------------------------------*\
 |             F O R W A R D   C L A S S   D E C L A R A T I O N S
\*---------------------------------------------------------------------------*/
class CCommPort; 

/*---------------------------------------------------------------------------*\
 |                      C L A S S   D E F I N I T I O N
\*---------------------------------------------------------------------------*/
class CNmeaParser
{
public:
	CNmeaParser(void) {}
	~CNmeaParser(void) {}

	bool    IsStartOfNmea(U8 ucByte); 
	void	Reset(); 
    int     ReceiveByte (U8 ucByte, U8 ucPkt[], int *pPktLen);
    CString ParsePkt   (U8 ucPkt[], int nPktLen);

	void SendPkt(CCommPort* pPort); 


private: //==== P R I V A T E   M E T H O D S ================================/

	CString ParseVR  (U8 ucPkt[], int nPktLen);
	CString ParseGGA (U8 ucPkt[], int nPktLen);
	CString ParseVTG (U8 ucPkt[], int nPktLen);

	int FormatVR (U8 ucPkt[]); 


	U8 ComputeChecksum(U8 ucPkt[], int nPktLen); 
	bool CheckChecksum(U8 ucPkt[], int nPktLen); 

	bool Matches(U8* pucPkt, const S8* pcRef);
	U32 GetHex(U8 *pcStr, U16 n); 

	bool GetNextField (U8* pucStr, S8* pcField, int* pOffset);
	bool GetNextFieldChar (U8* pucStr, S8* pcField, int* pOffset, U8* pChar);
	bool GetNextFieldInt (U8* pucStr, S8* pcField, int* pOffset, int* pInt);
	bool GetNextFieldDbl (U8* pucStr, S8* pcField, int* pOffset, DBL* pDbl);


	void FormatNmeaMsgHead (U8* pucStr, int* pPktLen, U8 ucMode, S8* pMsg);
	void FormatNmeaMsgTail (U8* pucStr, int* pPktLen);

	U8   DigitToHex(U8 ucDigit); 
	void PutNextField(U8* pucStr, S8* pcField, int* pOffset); 


private: //==== P R I V A T E   M E M B E R   V A R I A B L E S ==============/

	int m_nParseState;

};

#endif